<?php $__env->startSection('title'); ?>
    <?php if(request()->routeIs('report-templates.edit')): ?>
        <?php echo e(trans('general.update')); ?> <?php echo e($template->name); ?>

    <?php elseif(request()->routeIs('report-templates.show')): ?>
        <?php echo e(trans('general.custom_report')); ?>: <?php echo e($template->name); ?>

    <?php else: ?>
        <?php echo e(trans('general.custom_report')); ?>

    <?php endif; ?>
<?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header_right'); ?>
    <?php if(request()->routeIs('report-templates.edit')): ?>
        <a href="<?php echo e(route('report-templates.show', $template)); ?>" class="btn btn-primary pull-right">
            <?php echo e(trans('general.back')); ?>

        </a>
    <?php elseif(request()->routeIs('report-templates.show')): ?>
        <a href="<?php echo e(route('reports/custom')); ?>" class="btn btn-primary pull-right">
            <?php echo e(trans('general.back')); ?>

        </a>
    <?php else: ?>
        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-primary pull-right">
            <?php echo e(trans('general.back')); ?>

        </a>
    <?php endif; ?>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-md-9">

        <form
            method="POST"
            action="<?php echo e(request()->routeIs('report-templates.edit') ? route('report-templates.update', $template) : route('reports.post-custom')); ?>"
            accept-charset="UTF-8"
            class="form-horizontal"
            id="custom-report-form"
        >
        <?php echo e(csrf_field()); ?>


    <!-- Horizontal Form -->
        <div class="box box-default">
            <div class="box-header with-border">
                <?php if(request()->routeIs('reports/custom') || request()->routeIs('report-templates.show')): ?>
                    <h2 class="box-title" style="padding-top: 7px;">
                        <?php echo e(trans('general.customize_report')); ?>

                    </h2>

                <?php endif; ?>

                <?php if(request()->routeIs('report-templates.edit')): ?>
                    <div class="row">
                        <div class="col-md-7 col-md-offset-4">
                            <div class="<?php echo e($errors->has('name') ? ' has-error' : ''); ?>">
                                <label
                                    for="name"
                                    class="col-md-4 control-label"
                                >
                                    <?php echo e(trans('admin/reports/general.template_name')); ?>

                                </label>
                                <div class="col-md-8">
                                    <input
                                        class="form-control"
                                        placeholder=""
                                        name="name"
                                        type="text"
                                        id="name"
                                        value="<?php echo e($template->name); ?>"
                                        required
                                    >
                                </div>
                                <?php echo $errors->first('name', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                            </div>
                        </div>
                    </div>
                <?php endif; ?>

        </div><!-- /.box-header -->

        <div class="box-body">

            <div class="col-md-4" id="included_fields_wrapper">

                <label class="form-control">
                    <input type="checkbox" id="checkAll" checked="checked">
                    <?php echo e(trans('general.select_all')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="id" value="1" <?php if($template->checkmarkValue('id')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.id')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="company" value="1" <?php if($template->checkmarkValue('company')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.company')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="asset_tag" value="1" <?php if($template->checkmarkValue('asset_tag')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.asset_tag')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="asset_name" value="1" <?php if($template->checkmarkValue('asset_name')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/form.name')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="manufacturer" value="1" <?php if($template->checkmarkValue('manufacturer')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.manufacturer')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="model" value="1" <?php if($template->checkmarkValue('model')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.asset_model')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="category" value="1" <?php if($template->checkmarkValue('category')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.category')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="serial" value="1" <?php if($template->checkmarkValue('serial')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/table.serial')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="purchase_date" value="1" <?php if($template->checkmarkValue('purchase_date')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/licenses/table.purchase_date')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="purchase_cost" value="1" <?php if($template->checkmarkValue('purchase_cost')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/form.cost')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="eol" value="1" <?php if($template->checkmarkValue('eol')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/form.eol_date')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="warranty" value="1" <?php if($template->checkmarkValue('warranty')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/form.warranty')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="depreciation" value="1" <?php if($template->checkmarkValue('depreciation')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.depreciation')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="order" value="1" <?php if($template->checkmarkValue('order')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/form.order')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="supplier" value="1" <?php if($template->checkmarkValue('supplier')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.suppliers')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="location" value="1" <?php if($template->checkmarkValue('location')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.location')); ?>

                </label>

              <label class="form-control" style="margin-left: 25px;">
                  <input type="checkbox" name="location_address" value="1" <?php if($template->checkmarkValue('location_address')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('general.address')); ?>

              </label>

                <label class="form-control">
                    <input type="checkbox" name="rtd_location" value="1" <?php if($template->checkmarkValue('rtd_location')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/form.default_location')); ?>

                </label>

              <label class="form-control" style="margin-left: 25px;">
                  <input type="checkbox" name="rtd_location_address" value="1" <?php if($template->checkmarkValue('rtd_location_address')): echo 'checked'; endif; ?> />
                <?php echo e(trans('general.address')); ?>

              </label>

                <label class="form-control">
                    <input type="checkbox" name="status" value="1" <?php if($template->checkmarkValue('status')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.status')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="checkout_date" value="1" <?php if($template->checkmarkValue('checkout_date')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('admin/hardware/table.checkout_date')); ?>

                </label>

              <label class="form-control">
                  <input type="checkbox" name="checkin_date" value="1" <?php if($template->checkmarkValue('checkin_date')): echo 'checked'; endif; ?> />
                <?php echo e(trans('admin/hardware/table.last_checkin_date')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="expected_checkin" value="1" <?php if($template->checkmarkValue('expected_checkin')): echo 'checked'; endif; ?> />
                <?php echo e(trans('admin/hardware/form.expected_checkin')); ?>

              </label>

                <label class="form-control">
                    <input type="checkbox" name="created_at" value="1" <?php if($template->checkmarkValue('created_at')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.created_at')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="updated_at" value="1" <?php if($template->checkmarkValue('updated_at')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.updated_at')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="deleted_at" value="1" <?php if($template->checkmarkValue('deleted_at')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.deleted')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="last_audit_date" value="1" <?php if($template->checkmarkValue('last_audit_date')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.last_audit')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="next_audit_date" value="1" <?php if($template->checkmarkValue('next_audit_date')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.next_audit_date')); ?>

                </label>

                <label class="form-control">
                    <input type="checkbox" name="notes" value="1" <?php if($template->checkmarkValue('notes')): echo 'checked'; endif; ?> />
                    <?php echo e(trans('general.notes')); ?>

                </label>

              <label class="form-control" style="margin-left: 25px;">
                  <input type="checkbox" name="url" value="1" <?php if($template->checkmarkValue('url')): echo 'checked'; endif; ?> />
                <?php echo e(trans('general.url')); ?>

              </label>


            <!-- User fields -->

              <h2><?php echo e(trans('general.checked_out_to_fields')); ?>: </h2>

              <label class="form-control">
                  <input type="checkbox" name="assigned_to" value="1" <?php if($template->checkmarkValue('assigned_to')): echo 'checked'; endif; ?> />
                <?php echo e(trans('admin/licenses/table.assigned_to')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="username" value="1" <?php if($template->checkmarkValue('username')): echo 'checked'; endif; ?> />
                <?php echo e(trans('admin/users/table.username')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="employee_num" value="1" <?php if($template->checkmarkValue('employee_num')): echo 'checked'; endif; ?> />
                <?php echo e(trans('general.employee_number')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="manager" value="1" <?php if($template->checkmarkValue('manager')): echo 'checked'; endif; ?> />
                <?php echo e(trans('admin/users/table.manager')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="department" value="1" <?php if($template->checkmarkValue('department')): echo 'checked'; endif; ?> />
                <?php echo e(trans('general.department')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="title" value="1" <?php if($template->checkmarkValue('title')): echo 'checked'; endif; ?> />
                <?php echo e(trans('admin/users/table.title')); ?>

              </label>

                <!-- new -->

              <label class="form-control">
                  <input type="checkbox" name="phone" value="1" <?php if($template->checkmarkValue('phone')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('admin/users/table.phone')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="user_address" value="1" <?php if($template->checkmarkValue('user_address')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('general.address')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="user_city" value="1" <?php if($template->checkmarkValue('user_city')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('general.city')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="user_state" value="1" <?php if($template->checkmarkValue('user_state')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('general.state')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="user_country" value="1" <?php if($template->checkmarkValue('user_country')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('general.country')); ?>

              </label>

              <label class="form-control">
                  <input type="checkbox" name="user_zip" value="1" <?php if($template->checkmarkValue('user_zip')): echo 'checked'; endif; ?> />
                  <?php echo e(trans('general.zip')); ?>

              </label>



            <?php if($customfields->count() > 0): ?>

                <h2><?php echo e(trans('admin/custom_fields/general.custom_fields')); ?></h2>

              <?php $__currentLoopData = $customfields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customfield): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                  <label class="form-control">
                      <input type="checkbox" name="<?php echo e($customfield->db_column_name()); ?>" value="1" <?php if($template->checkmarkValue($customfield->db_column_name())): echo 'checked'; endif; ?> />
                    <?php echo e($customfield->name); ?>

                  </label>

              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </div> <!-- /.col-md-4-->

          <div class="col-md-8">

            <p>
                <?php echo trans('general.report_fields_info'); ?>

            </p>

              <br>

            <?php echo $__env->make('partials.forms.edit.company-select', [
                    'translated_name' => trans('general.company'),
                    'fieldname' =>
                    'by_company_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_company_id', \App\Models\Company::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.location-select', [
                    'translated_name' => trans('general.location'),
                    'fieldname' => 'by_location_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_location_id', \App\Models\Location::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.location-select', [
                    'translated_name' => trans('admin/hardware/form.default_location'),
                    'fieldname' => 'by_rtd_location_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_rtd_location_id', \App\Models\Location::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.department-select',[
                    'translated_name' => trans('general.department'),
                    'fieldname' => 'by_dept_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_dept_id', \App\Models\Department::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.supplier-select', [
                    'translated_name' => trans('general.supplier'),
                    'fieldname' => 'by_supplier_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_supplier_id', \App\Models\Supplier::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.model-select', [
                    'translated_name' => trans('general.asset_model'),
                    'fieldname' => 'by_model_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_model_id', \App\Models\AssetModel::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.manufacturer-select', [
                    'translated_name' => trans('general.manufacturer'),
                    'fieldname' => 'by_manufacturer_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_manufacturer_id', \App\Models\Manufacturer::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.category-select', [
                    'translated_name' => trans('general.category'),
                    'fieldname' => 'by_category_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'category_type' => 'asset',
                    'selected' => $template->selectValues('by_category_id', \App\Models\Category::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.forms.edit.status-select', [
                    'translated_name' => trans('admin/hardware/form.status'),
                    'fieldname' => 'by_status_id[]',
                    'multiple' => 'true',
                    'hide_new' => 'true',
                    'selected' => $template->selectValues('by_status_id', \App\Models\Statuslabel::class),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Order Number -->
            <div class="form-group">
              <label for="by_order_number" class="col-md-3 control-label"><?php echo e(trans('general.order_number')); ?></label>
              <div class="col-md-7">
                <input class="form-control" type="text" name="by_order_number" value="<?php echo e($template->textValue('by_order_number', old('by_order_number'))); ?>" aria-label="by_order_number">
              </div>
            </div>

          <!-- Purchase Date -->
            <div class="form-group purchase-range<?php echo e(($errors->has('purchase_start') || $errors->has('purchase_end')) ? ' has-error' : ''); ?>">
              <label for="purchase_start" class="col-md-3 control-label"><?php echo e(trans('general.purchase_date')); ?></label>
              <div class="input-daterange input-group col-md-7" id="purchase-range-datepicker">
                  <input type="text" class="form-control" name="purchase_start" aria-label="purchase_start" value="<?php echo e($template->textValue('purchase_start', old('purchase_start'))); ?>">
                  <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                  <input type="text" class="form-control" name="purchase_end" aria-label="purchase_end" value="<?php echo e($template->textValue('purchase_end', old('purchase_end'))); ?>">
              </div>

                <?php if($errors->has('purchase_start') || $errors->has('purchase_end')): ?>
                    <div class="col-md-9 col-lg-offset-3">
                        <?php echo $errors->first('purchase_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                        <?php echo $errors->first('purchase_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                    </div>
                <?php endif; ?>

            </div>

            <!-- Created Date -->
            <div class="form-group created-range<?php echo e(($errors->has('created_start') || $errors->has('created_end')) ? ' has-error' : ''); ?>">
              <label for="created_start" class="col-md-3 control-label"><?php echo e(trans('general.created_at')); ?> </label>
              <div class="input-daterange input-group col-md-7" id="created-range-datepicker">
                  <input type="text" class="form-control" name="created_start" aria-label="created_start" value="<?php echo e($template->textValue('created_start', old('created_start'))); ?>">
                  <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                  <input type="text" class="form-control" name="created_end" aria-label="created_end" value="<?php echo e($template->textValue('created_end', old('created_end'))); ?>">
              </div>

                <?php if($errors->has('created_start') || $errors->has('created_end')): ?>
                    <div class="col-md-9 col-lg-offset-3">
                        <?php echo $errors->first('created_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                        <?php echo $errors->first('created_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                    </div>
                <?php endif; ?>
            </div>

          <!-- Checkout Date -->
          <div class="form-group checkout-range<?php echo e(($errors->has('checkout_date_start') || $errors->has('checkout_date_end')) ? ' has-error' : ''); ?>">
              <label for="checkout_date" class="col-md-3 control-label"><?php echo e(trans('general.checkout')); ?> </label>
              <div class="input-daterange input-group col-md-7" id="checkout-range-datepicker">
                  <input type="text" class="form-control" name="checkout_date_start" aria-label="checkout_date_start" value="<?php echo e($template->textValue('checkout_date_start', old('checkout_date_start'))); ?>">
                  <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                  <input type="text" class="form-control" name="checkout_date_end" aria-label="checkout_date_end" value="<?php echo e($template->textValue('checkout_date_end', old('checkout_date_end'))); ?>">
              </div>

              <?php if($errors->has('checkout_date_start') || $errors->has('checkout_date_end')): ?>
                  <div class="col-md-9 col-lg-offset-3">
                      <?php echo $errors->first('checkout_date_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                      <?php echo $errors->first('checkout_date_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                  </div>
              <?php endif; ?>

          </div>

          <!-- Last Checkin Date -->
          <div class="form-group checkin-range<?php echo e(($errors->has('checkin_date_start') || $errors->has('checkin_date_end')) ? ' has-error' : ''); ?>">
              <label for="checkin_date" class="col-md-3 control-label"><?php echo e(trans('admin/hardware/table.last_checkin_date')); ?></label>
              <div class="input-daterange input-group col-md-7" id="checkin-range-datepicker">
                  <input type="text" class="form-control" name="checkin_date_start" aria-label="checkin_date_start" value="<?php echo e($template->textValue('checkin_date_start', old('checkin_date_start'))); ?>">
                  <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                  <input type="text" class="form-control" name="checkin_date_end" aria-label="checkin_date_end" value="<?php echo e($template->textValue('checkin_date_end', old('checkin_date_end'))); ?>">
              </div>

              <?php if($errors->has('checkin_date_start') || $errors->has('checkin_date_end')): ?>
                  <div class="col-md-9 col-lg-offset-3">
                      <?php echo $errors->first('checkin_date_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                      <?php echo $errors->first('checkin_date_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                  </div>
              <?php endif; ?>
          </div>

            <!-- Expected Checkin Date -->
            <div class="form-group expected_checkin-range<?php echo e(($errors->has('expected_checkin_start') || $errors->has('expected_checkin_end')) ? ' has-error' : ''); ?>">
              <label for="expected_checkin_start" class="col-md-3 control-label"><?php echo e(trans('admin/hardware/form.expected_checkin')); ?></label>
              <div class="input-daterange input-group col-md-7" id="expected_checkin-range-datepicker">
                  <input type="text" class="form-control" name="expected_checkin_start" aria-label="expected_checkin_start" value="<?php echo e($template->textValue('expected_checkin_start', old('expected_checkin_start'))); ?>">
                  <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                  <input type="text" class="form-control" name="expected_checkin_end" aria-label="expected_checkin_end" value="<?php echo e($template->textValue('expected_checkin_end', old('expected_checkin_end'))); ?>">
              </div>

                <?php if($errors->has('expected_checkin_start') || $errors->has('expected_checkin_end')): ?>
                    <div class="col-md-9 col-lg-offset-3">
                        <?php echo $errors->first('expected_checkin_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                        <?php echo $errors->first('expected_checkin_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                    </div>
                <?php endif; ?>

            </div>

              <!-- EoL Date -->
              <div class="form-group asset_eol_date-range <?php echo e(($errors->has('asset_eol_date_start') || $errors->has('asset_eol_date_end')) ? ' has-error' : ''); ?>">
                  <label for="asset_eol_date" class="col-md-3 control-label"><?php echo e(trans('admin/hardware/form.eol_date')); ?></label>
                  <div class="input-daterange input-group col-md-7" id="asset_eol_date-range-datepicker">
                      <input type="text" class="form-control" name="asset_eol_date_start" aria-label="asset_eol_date_start" value="<?php echo e($template->textValue('asset_eol_date_start', old('asset_eol_date_start'))); ?>">
                      <span class="input-group-addon">to</span>
                      <input type="text" class="form-control" name="asset_eol_date_end" aria-label="asset_eol_date_end" value="<?php echo e($template->textValue('asset_eol_date_end', old('asset_eol_date_end'))); ?>">
                  </div>

                  <?php if($errors->has('asset_eol_date_start') || $errors->has('asset_eol_date_end')): ?>
                      <div class="col-md-9 col-lg-offset-3">
                          <?php echo $errors->first('asset_eol_date_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                          <?php echo $errors->first('asset_eol_date_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                      </div>
                  <?php endif; ?>
              </div>

              <!-- Last Audit Date -->
              <div class="form-group last_audit-range<?php echo e(($errors->has('last_audit_start') || $errors->has('last_audit_end')) ? ' has-error' : ''); ?>">
                  <label for="last_audit_start" class="col-md-3 control-label"><?php echo e(trans('general.last_audit')); ?></label>
                  <div class="input-daterange input-group col-md-7" id="last_audit-range-datepicker">
                      <input type="text" class="form-control" name="last_audit_start" aria-label="last_audit_start" value="<?php echo e($template->textValue('last_audit_start', old('last_audit_start'))); ?>">
                      <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                      <input type="text" class="form-control" name="last_audit_end" aria-label="last_audit_end" value="<?php echo e($template->textValue('last_audit_end', old('last_audit_end'))); ?>">
                  </div>

                  <?php if($errors->has('last_audit_start') || $errors->has('last_audit_end')): ?>
                      <div class="col-md-9 col-lg-offset-3">
                          <?php echo $errors->first('last_audit_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                          <?php echo $errors->first('last_audit_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                      </div>
                  <?php endif; ?>
              </div>

              <!-- Next Audit Date -->
              <div class="form-group next_audit-range<?php echo e(($errors->has('next_audit_start') || $errors->has('next_audit_end')) ? ' has-error' : ''); ?>">
                  <label for="next_audit_start" class="col-md-3 control-label"><?php echo e(trans('general.next_audit_date')); ?></label>
                  <div class="input-daterange input-group col-md-7" id="next_audit-range-datepicker">
                      <input type="text" class="form-control" name="next_audit_start" aria-label="next_audit_start" value="<?php echo e($template->textValue('next_audit_start', old('next_audit_start'))); ?>">
                      <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                      <input type="text" class="form-control" name="next_audit_end" aria-label="next_audit_end" value="<?php echo e($template->textValue('next_audit_end', old('next_audit_end'))); ?>">
                  </div>

                  <?php if($errors->has('next_audit_start') || $errors->has('next_audit_end')): ?>
                      <div class="col-md-9 col-lg-offset-3">
                          <?php echo $errors->first('next_audit_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                          <?php echo $errors->first('next_audit_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                      </div>
                  <?php endif; ?>
              </div>

              <!-- Last updated Date -->
              <div class="form-group last_updated-range<?php echo e(($errors->has('last_updated_start') || $errors->has('last_updated_end')) ? ' has-error' : ''); ?>">
                  <label for="last_updated_start" class="col-md-3 control-label"><?php echo e(trans('general.updated_at')); ?></label>
                  <div class="input-daterange input-group col-md-7" id="last_updated-range-datepicker">
                      <input type="text" class="form-control" name="last_updated_start" aria-label="last_updated_start" value="<?php echo e($template->textValue('last_updated_start', old('last_updated_start'))); ?>">
                      <span class="input-group-addon"><?php echo e(strtolower(trans('general.to'))); ?></span>
                      <input type="text" class="form-control" name="last_updated_end" aria-label="last_updated_end" value="<?php echo e($template->textValue('last_updated_end', old('last_updated_end'))); ?>">
                  </div>

                  <?php if($errors->has('last_updated_start') || $errors->has('last_updated_end')): ?>
                      <div class="col-md-9 col-lg-offset-3">
                          <?php echo $errors->first('last_updated_start', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                          <?php echo $errors->first('last_updated_end', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                      </div>
                  <?php endif; ?>

              </div>

            <div class="col-md-9 col-md-offset-3">
            <label class="form-control">
                <input type="checkbox" name="exclude_archived" value="1" <?php if($template->checkmarkValue('exclude_archived', '0')): echo 'checked'; endif; ?> />
              <?php echo e(trans('general.exclude_archived')); ?>

            </label>
            </div>
            <div class="col-md-9 col-md-offset-3">
              <label class="form-control">
                  <input type="checkbox" name="use_bom" value="1" <?php if($template->checkmarkValue('use_bom', '0')): echo 'checked'; endif; ?> />
                <?php echo e(trans('general.bom_remark')); ?>

              </label>
            </div>

              <div class="col-md-9 col-md-offset-3">
                  <label class="form-control">
                      <input
                          name="deleted_assets"
                          id="deleted_assets_exclude_deleted"
                          type="radio"
                          value="exclude_deleted"
                          <?php if($template->radioValue('deleted_assets', 'exclude_deleted', true)): echo 'checked'; endif; ?>
                          aria-label="deleted_assets"
                      >
                      <?php echo e(trans('general.exclude_deleted')); ?>

                  </label>
                  <label class="form-control">
                      <input
                          name="deleted_assets"
                          id="deleted_assets_include_deleted"
                          type="radio"
                          value="include_deleted"
                          <?php if($template->radioValue('deleted_assets', 'include_deleted')): echo 'checked'; endif; ?>
                          aria-label="deleted_assets"
                      >
                    <?php echo e(trans('general.include_deleted')); ?>

                  </label>
                  <label class="form-control">
                      <input
                          name="deleted_assets"
                          type="radio"
                          id="deleted_assets_only_deleted"
                          value="only_deleted"
                          <?php if($template->radioValue('deleted_assets', 'only_deleted')): echo 'checked'; endif; ?>
                          aria-label="deleted_assets"
                      >
                    <?php echo e(trans('general.only_deleted')); ?>

                  </label>
              </div>
          </div>

        </div> <!-- /.box-body-->
            <div class="box-footer text-right">
                <?php if(request()->routeIs('report-templates.edit')): ?>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-check icon-white" aria-hidden="true"></i>
                        <?php echo e(trans('general.save')); ?>

                    </button>
                <?php else: ?>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-download icon-white" aria-hidden="true"></i>
                        <?php echo e(trans('general.generate')); ?>

                    </button>
                <?php endif; ?>
            </div>
        </div> <!--/.box.box-default-->
        </form>
    </div>

    <!-- Saved Reports right column -->
    <div class="col-md-3">
        <?php if(! request()->routeIs('report-templates.edit')): ?>
            <div class="form-group">
                <label for="saved_report_select"><?php echo e(trans('admin/reports/general.open_saved_template')); ?></label>
                <select
                    id="saved_report_select"
                    class="form-control select2"
                    data-placeholder="<?php echo e(trans('admin/reports/general.select_a_template')); ?>"
                >
                    <option></option>
                    <?php $__currentLoopData = $report_templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $savedTemplate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option
                            value="<?php echo e($savedTemplate->id); ?>"
                            data-route="<?php echo e(route('report-templates.show', $savedTemplate->id)); ?>"
                            <?php if($savedTemplate->is(request()->route()->parameter('reportTemplate'))): echo 'selected'; endif; ?>
                        >
                            <?php echo e($savedTemplate->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="row">
                <div class="col-md-12">
                <?php if(request()->routeIs('report-templates.show')): ?>
                        <a
                                href="<?php echo e(route('report-templates.edit', $template)); ?>"
                                class="btn btn-sm btn-warning btn-social btn-block"
                                data-tooltip="true"
                                title="<?php echo e(trans('admin/reports/general.update_template')); ?>"
                                style="margin-bottom: 5px;"
                        >
                            <?php if (isset($component)) { $__componentOriginalce262628e3a8d44dc38fd1f3965181bc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalce262628e3a8d44dc38fd1f3965181bc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'bf5d1b266092032f179643f7f851bad6::icon','data' => ['type' => 'edit']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'edit']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalce262628e3a8d44dc38fd1f3965181bc)): ?>
<?php $attributes = $__attributesOriginalce262628e3a8d44dc38fd1f3965181bc; ?>
<?php unset($__attributesOriginalce262628e3a8d44dc38fd1f3965181bc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalce262628e3a8d44dc38fd1f3965181bc)): ?>
<?php $component = $__componentOriginalce262628e3a8d44dc38fd1f3965181bc; ?>
<?php unset($__componentOriginalce262628e3a8d44dc38fd1f3965181bc); ?>
<?php endif; ?>
                            <?php echo e(trans('general.update')); ?>

                        </a>

                    <span data-tooltip="true" title="<?php echo e(trans('general.delete')); ?>">
                        <a href="#"
                                class="btn btn-sm btn-danger btn-social btn-block"
                                data-toggle="modal"
                                data-title="<?php echo e(trans('general.delete')); ?>"
                                data-content="<?php echo e(trans('general.delete_confirm', ['item' => $template->name])); ?>"
                                data-target="#dataConfirmModal"
                                type="button"
                        >

                                <?php if (isset($component)) { $__componentOriginalce262628e3a8d44dc38fd1f3965181bc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalce262628e3a8d44dc38fd1f3965181bc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'bf5d1b266092032f179643f7f851bad6::icon','data' => ['type' => 'delete']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'delete']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalce262628e3a8d44dc38fd1f3965181bc)): ?>
<?php $attributes = $__attributesOriginalce262628e3a8d44dc38fd1f3965181bc; ?>
<?php unset($__attributesOriginalce262628e3a8d44dc38fd1f3965181bc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalce262628e3a8d44dc38fd1f3965181bc)): ?>
<?php $component = $__componentOriginalce262628e3a8d44dc38fd1f3965181bc; ?>
<?php unset($__componentOriginalce262628e3a8d44dc38fd1f3965181bc); ?>
<?php endif; ?>
                                <?php echo e(trans('general.delete')); ?>


                        </a>
                    </span>


                <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php if(request()->routeIs('reports/custom')): ?>
            <hr>
            <div class="form-group">
                <form method="post" id="savetemplateform" action="<?php echo e(route("report-templates.store")); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" id="savetemplateform" name="options">
                    <div class="form-group<?php echo e($errors->has('name') ? ' has-error' : ''); ?>">
                        <label for="name"><?php echo e(trans('admin/reports/general.template_name')); ?></label>
                        <input
                            class="form-control"
                            placeholder=""
                            name="name"
                            type="text"
                            id="name"
                            value="<?php echo e($template->name); ?>"
                            required
                        >
                        <?php echo $errors->first('name', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-times" aria-hidden="true"></i> :message</span>'); ?>

                    </div>
                    <button class="btn btn-primary" style="width: 100%">
                        <?php echo e(trans('admin/reports/general.save_template')); ?>

                    </button>
                </form>
            </div>
            <div class="box box-success">
                <div class="box-header with-border">
                    <h4><?php echo e(trans('admin/reports/message.about_templates')); ?></h4>
                </div>
                <div class="box-body">
                    <p><?php echo trans('admin/reports/message.saving_templates_description'); ?></p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('moar_scripts'); ?>
  <script>

      $('.purchase-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          endDate: '0d',
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.created-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          endDate: '0d',
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.checkout-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          endDate: '0d',
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.checkin-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          endDate: '0d',
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.expected_checkin-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.asset_eol_date-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.last_audit-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          endDate:'0d',
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.next_audit-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });

      $('.last_updated-range .input-daterange').datepicker({
          clearBtn: true,
          todayHighlight: true,
          endDate:'0d',
          format: 'yyyy-mm-dd',
          keepEmptyValues: true,
      });


      $("#checkAll").change(function () {
        $("#included_fields_wrapper input:checkbox").prop('checked', $(this).prop("checked"));
      });

      $("#savetemplateform").submit(function(e) {
          e.preventDefault(e);

          let form = $('#custom-report-form');
          $('<input>').attr({
              type: 'hidden',
              name: 'name',
              value: $('#name').val(),
          }).appendTo(form);

          form.attr('action', '<?php echo e(route('report-templates.store')); ?>').submit();
      });

      $('#saved_report_select')
          .on('select2:select', function (event) {
              window.location.href = event.params.data.element.dataset.route;
          });

      $('#dataConfirmModal').on('show.bs.modal', function (event) {
          var content = $(event.relatedTarget).data('content');
          var title = $(event.relatedTarget).data('title');
          $(this).find(".modal-body").text(content);
          $(this).find(".modal-header").text(title);
      });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/vinkblgn/asset.visuretech.com/resources/views/reports/custom.blade.php ENDPATH**/ ?>